/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeetingService.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "ObjCHelpers.h"
#import "ObjcWrapperCache.h"
#import "CSISecureString.h"
#import <Foundation/NSDate.h>
#import "ObjectFoundry.h"
#import <objc/runtime.h>

#import "JCFUnifiedService.h"
#import "JCFMeetingService.h"
#import "JCFMeeting.h"
#include "csfunified/services/interface/Meeting.h"
#include "csfunified/services/interface/CalendarType_enum.h"
#import "JCFCMRMeetingCallback.h"
#include "csfunified/services/interface/MailServiceType_enum.h"
#import "JCFMeetingMgrController.h"
#include "csfunified/services/interface/MeetingMgrController.h"
#import "JCFDesktopSharingController.h"
#include "csfunified/services/interface/DesktopSharingController.h"
#import "JCFMeetingAccountController.h"
#include "csfunified/services/interface/MeetingAccountController.h"
#import "JCFCMRController.h"
#include "csfunified/services/interface/CMRController.h"

//cpp interface
#include "csfunified/services/interface/MeetingService.h" 



NSString * const JCFMeetingServiceMeetingsDidChangeNotification = @"JCFMeetingServiceMeetingsDidChangeNotification";
NSString * const JCFMeetingServiceMeetingContentDidChangeNotification = @"JCFMeetingServiceMeetingContentDidChangeNotification";
NSString * const JCFMeetingServiceIntegrationCalendarTypeDidChangeNotification = @"JCFMeetingServiceIntegrationCalendarTypeDidChangeNotification";
NSString * const JCFMeetingServiceIsCMREnabledDidChangeNotification = @"JCFMeetingServiceIsCMREnabledDidChangeNotification";

#include <map>

typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingService> MeetingServicePtr;
typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingServiceObserver> MeetingServiceObserverPtr;

typedef SMART_PTR_NS::weak_ptr<CSFUnified::MeetingService> MeetingServiceWPtr;
typedef std::owner_less<MeetingServiceWPtr> wp_less;
typedef std::map<MeetingServiceWPtr, JCFMeetingService*, wp_less> MeetingServiceCache;
static MeetingServiceCache sCache;

@interface JCFMeetingService ()

@property (nonatomic, readwrite, assign) struct MeetingServiceOpaque *cpp;

-(id)initWithMeetingServicePtr:(MeetingServicePtr)meetingService;

@end

#include "JCFMeetingServiceObserver.h"

struct MeetingServiceOpaque
{
	
	MeetingServiceOpaque(JCFMeetingService* ObjcOwner, MeetingServicePtr meetingService) 
	:mMeetingService(meetingService),
	mMeetingServiceObserver(new JCFMeetingServiceObserver(ObjcOwner))
	{
		mMeetingService->addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingServiceObserver>(mMeetingServiceObserver));
	};
	
	~MeetingServiceOpaque() 
	{
		mMeetingService->removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingServiceObserver>(mMeetingServiceObserver));
	};
	
	MeetingServicePtr mMeetingService;
	
private:
	MeetingServiceObserverPtr mMeetingServiceObserver;
};

@implementation JCFMeetingService

@synthesize cpp = mMeetingServiceCpp;

#pragma mark Base Unified Business Object Properties





-(NSArray*) meetings
{
	SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::Meeting> > > vectorCPP;

	std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::Meeting> >::const_iterator iter;

    vectorCPP = self.cpp->mMeetingService->getMeetings();

    NSMutableArray *array= [NSMutableArray array];
    
    for (int i=0; i != vectorCPP->size(); i++)
    {
    
    [array addObject:[Forge(SMART_PTR_NS::static_pointer_cast<CSFUnified::UnifiedBusinessObject>(vectorCPP->at(i))) autorelease]];
    
    }
    return array;
}


-(NSString*) meetingContent
{
	
    std::string stringCpp = self.cpp->mMeetingService->getMeetingContent();
	return JCFNSStringForStdString(stringCpp);
	}


-(JCFCalendarType) integrationCalendarType
{
	return ((JCFCalendarType)self.cpp->mMeetingService->getIntegrationCalendarType());
}
-(void) setIntegrationCalendarType:(JCFCalendarType) ObjcEnumValue
{
	self.cpp->mMeetingService->setIntegrationCalendarType((CSFUnified::CalendarTypeEnum::CalendarType)ObjcEnumValue);
}


-(BOOL) isCMREnabled
{
    return self.cpp->mMeetingService->getIsCMREnabled();
}




#pragma mark Constructors

-(JCFMeetingService*) initWithMeetingServicePtr:(MeetingServicePtr)meetingService
{
	@synchronized([self class])
	{
		MeetingServiceWPtr wp(meetingService);
		MeetingServiceCache::const_iterator iter = sCache.find(wp);
		if (iter != sCache.end())
		{
			[self release];
			self = [(*iter).second retain];
		}
		else
		{
			self = [super initSuperWithUnifiedServicePtr : meetingService];
			if (self != nil)
			{
				if ([self class] == [JCFMeetingService class])
				{
					if (meetingService != NULL)
					{
						self.cpp = new MeetingServiceOpaque(self, meetingService);
						sCache[wp] = self;
					}
					else
					{
						[self release];
						self = nil;
					}
				}
			}
		}
	}

	return self;
}

-(JCFMeetingService*) initSuperWithMeetingServicePtr:(MeetingServicePtr)meetingService
{
	self = [super initSuperWithUnifiedServicePtr : meetingService];

	if (self != nil)
	{
		if ([self class] == [JCFMeetingService class])
		{
			if (meetingService == NULL)
			{
				[self release];
				self = nil;
			}
		}
	}
	return self;
}

-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr
{
	MeetingServicePtr meetingService = SMART_PTR_NS::dynamic_pointer_cast<CSFUnified::MeetingService>(cppPtr);
	self = [self initWithMeetingServicePtr: meetingService ];
	return self;
}

-(JCFMeetingService*) init
{
    NSAssert(NO, @"init with initWithMeetingServicePtr:");
    [self release];
    self = nil;
	return nil;
}

+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey {
	
	if([theKey isEqualToString:@"meetings"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"meetingContent"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"integrationCalendarType"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"isCMREnabled"])
	{
		return NO;
	}
	return [super automaticallyNotifiesObserversForKey:theKey];
}

+ (BOOL)accessInstanceVariablesDirectly
{
	return NO;
}

- (void)willChangeValueForKey:(NSString *)key
{
	kvoUpdate = YES;

	[super willChangeValueForKey:key];
}

- (void)didChangeValueForKey:(NSString *)key
{
	kvoUpdate = NO;
	[super didChangeValueForKey:key];
}

- (void)addObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
	
	if([keyPath hasPrefix:@"meetings"])
	{
		objc_setAssociatedObject(observer, &mMeetings, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"meetingContent"])
	{
		objc_setAssociatedObject(observer, &mMeetingContent, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"integrationCalendarType"])
	{
		objc_setAssociatedObject(observer, &mIntegrationCalendarType, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"isCMREnabled"])
	{
		objc_setAssociatedObject(observer, &mIsCMREnabled, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}

	[super addObserver:observer forKeyPath:keyPath options:options context:context];
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath context:(void *)context
{
	[super removeObserver:observer forKeyPath:keyPath context:context];

	
	if([keyPath hasPrefix:@"meetings"])
	{
		objc_setAssociatedObject(observer, &mMeetings, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"meetingContent"])
	{
		objc_setAssociatedObject(observer, &mMeetingContent, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"integrationCalendarType"])
	{
		objc_setAssociatedObject(observer, &mIntegrationCalendarType, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"isCMREnabled"])
	{
		objc_setAssociatedObject(observer, &mIsCMREnabled, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath
{
	[super removeObserver:observer forKeyPath:keyPath];

	
	if([keyPath hasPrefix:@"meetings"])
	{
		objc_setAssociatedObject(observer, &mMeetings, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"meetingContent"])
	{
		objc_setAssociatedObject(observer, &mMeetingContent, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"integrationCalendarType"])
	{
		objc_setAssociatedObject(observer, &mIntegrationCalendarType, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"isCMREnabled"])
	{
		objc_setAssociatedObject(observer, &mIsCMREnabled, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

-(void)dealloc
{
	@synchronized([self class])
	{
		if (self.cpp != NULL)
		{
			MeetingServiceWPtr wp(self.cpp->mMeetingService);
			sCache.erase(wp);

	  		delete self.cpp;
  			self.cpp = NULL;
	  	}
	}

  	[super dealloc];
}

-(MeetingServicePtr) getMeetingServicePtr
{
	return self.cpp->mMeetingService;
}


-(BOOL) isMeetingModuleEnabled
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingService->isMeetingModuleEnabled();
	return resultCpp;
}

-(BOOL) isDesktopShareModuleEnable
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingService->isDesktopShareModuleEnable();
	return resultCpp;
}

-(JCFMailServiceType) getDefaultMailClient
{


	CSFUnified::MailServiceTypeEnum::MailServiceType resultCpp;
	
	resultCpp = self.cpp->mMeetingService->getDefaultMailClient();
	return (JCFMailServiceType)resultCpp;
}


-(JCFMeetingMgrController*) getMeetingMgrController
{


	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> resultCpp;
	
	resultCpp = self.cpp->mMeetingService->getMeetingMgrController();
	JCFMeetingMgrController* resultObjc = [[[JCFMeetingMgrController alloc] initWithMeetingMgrControllerPtr:resultCpp] autorelease];
	return resultObjc;
}

-(JCFDesktopSharingController*) getDesktopSharingController
{


	SMART_PTR_NS::shared_ptr<CSFUnified::DesktopSharingController> resultCpp;
	
	resultCpp = self.cpp->mMeetingService->getDesktopSharingController();
	JCFDesktopSharingController* resultObjc = [[[JCFDesktopSharingController alloc] initWithDesktopSharingControllerPtr:resultCpp] autorelease];
	return resultObjc;
}

-(JCFMeetingAccountController*) getMeetingAccountController
{


	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> resultCpp;
	
	resultCpp = self.cpp->mMeetingService->getMeetingAccountController();
	JCFMeetingAccountController* resultObjc = [[[JCFMeetingAccountController alloc] initWithMeetingAccountControllerPtr:resultCpp] autorelease];
	return resultObjc;
}

-(JCFCMRController*) getCMRController:(NSString*)JID 
{

	std::string JIDCpp;

	SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> resultCpp;
	
	JIDCpp = JCFStdStringForNSString(JID);
	resultCpp = self.cpp->mMeetingService->getCMRController(JIDCpp);
	JCFCMRController* resultObjc = [[[JCFCMRController alloc] initWithCMRControllerPtr:resultCpp] autorelease];
	return resultObjc;
}

-(void) registerCMRMeetingCallback:(id<JCFCMRMeetingCallbackDelegate>)callback 
{
JCFCMRMeetingCallback *cbcallback;

	JCFCMRMeetingCallback *testcallback = [[[JCFCMRMeetingCallback alloc] init] autorelease];
	testcallback.delegate = callback;
	if([ObjcWrapperCache isCallbackCached:testcallback])
	{
		cbcallback = (JCFCMRMeetingCallback*)[ObjcWrapperCache getCachedCallback:testcallback];
		[cbcallback retain];
	}
	else
	{
		cbcallback = [[JCFCMRMeetingCallback alloc] init];
		cbcallback.delegate = callback;
		[ObjcWrapperCache cacheCallback:cbcallback];
	}
	testcallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callbackCpp;

	
	callbackCpp = cbcallback.getCppCallback;
	self.cpp->mMeetingService->registerCMRMeetingCallback(callbackCpp);
	[cbcallback release];
}

-(void) unregisterCMRMeetingCallback:(id<JCFCMRMeetingCallbackDelegate>)callback 
{
JCFCMRMeetingCallback *cbcallback;

	JCFCMRMeetingCallback *testcallback = [[[JCFCMRMeetingCallback alloc] init] autorelease];
	testcallback.delegate = callback;
	if([ObjcWrapperCache isCallbackCached:testcallback])
	{
		cbcallback = (JCFCMRMeetingCallback*)[ObjcWrapperCache getCachedCallback:testcallback];
		[cbcallback retain];
	}
	else
	{
		cbcallback = [[JCFCMRMeetingCallback alloc] init];
		cbcallback.delegate = callback;
		[ObjcWrapperCache cacheCallback:cbcallback];
	}
	testcallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callbackCpp;

	
	callbackCpp = cbcallback.getCppCallback;
	self.cpp->mMeetingService->unregisterCMRMeetingCallback(callbackCpp);
	[cbcallback release];
}

-(void) loggedIn
{


	
	self.cpp->mMeetingService->loggedIn();
}

-(void) loggedOut
{


	
	self.cpp->mMeetingService->loggedOut();
}



@end